<?php
//
// Automatische Verzeichnisgenerierung fr http://www.skriptweb.de
//
// (c) 2002 Christoph Moder cmoder@bigfoot.com, cm@skriptweb.de
// Dieses Programm unterliegt der GNU GPL, siehe http://www.gnu.org/copyleft/gpl.html
//
//
// Benutzung:
// ~~~~~~~~~
// In ein Verzeichnis dieses PHP-Skript sowie die Dateien head.html und tail.html 
// kopieren.
// Dabei enthlt head.html den Kopf des Listings (mind. bis einschl. <BODY>-Tag),
// und tail.html den Fu des Listings (d.h. mindestens </BODY></HTML>).
// Achtung: der Webserver (der das PHP-Programm ausfhrt) muss Schreibrechte in
// diesem Verzeichnis haben (index.html wird angelegt).
//
// Jedes Unterverzeichnis erscheint als eine <H2>-berschrift, und alle Dateien
// darin werden in einer <UL>-Liste aufgelistet und verlinkt.
// Zu jeder Datei wird auerdem die Gre (in kB) und, wenn es sich um PDF-
// Dateien handelt, die Seitenanzahl ermittelt und kursiv unter den Link hingeschrieben.
//
// Gibt es eine Datei mit dem selben Namen, aber der Endung .txt, dann wird diese
// Datei zur Beschreibung der anderen verwendet (ansonsten wird nur als Link
// der Dateiname verwendet). In der ersten Zeile steht der Linktext, in den
// folgenden Zeilen die Beschreibung. 
// Achtung: Sonderzeichen mssen HTML-kodiert werden, z.B. ein '' als &auml;
//
// Gibt es ein Unterverzeichnis mit dem selben Namen (aber ohne Endung),
// dann werden alle darin befindlichen Dateien als zugehrig betrachtet
// und unter dem Listeneintrag aufgelistet (in einer verschachtelten
// und damit weiter eingerckten Liste).
// Hier gilt ebenfalls, dass alle Dateien in diesem Unterverzeichnis eine
// Beschriftung bekommen, wenn es Dateien gleichen Namens mit der Endung .txt
// und beschreibendem Inhalt gibt.
// Unterverzeichnisse knnen mehrfach verschachtelt werden; haben zwei Dateien
// den gleichen Namen, aber verschiedene Endungen, dann erscheint der
// Inhalt des Unterverzeichnisses mit gemeinsamem Namen bei beiden.
?>

<HTML>

<HEAD>
	<TITLE>Skriptweb - dynamische Verzeichniserzeugung</TITLE>
</HEAD>

<BODY bgcolor="#FFFFFF">

	<H1>Dynamische Verzeichniserzeugung</H1>

<?php

// speichert die momentane Position im Verzeichnisbaum, damit korrekte Pfade fr die Links erzeugt werden knnen
$current_dir = array();

// soll der Downloadcounter benutzt werden oder nicht?
$use_downloadcounter = 1;

// Ermittelt die Seitenzahl einer PDF-Datei, indem die Datei geffnet wird und nach dem Pages-Objekt gesucht wird
// (befindet sich zwischen "Type /Pages" und "endobj"). Dort steht die Seitenzahl drinnen (z.B. "/Count 12").
function count_pdf_pages( $filename )
{
//FIXME!!! Warum funktioniert "or return 0" nicht?
	$pdffile = fopen( $filename, "rb" ); // or return 0;
	$in_page_tree = 0;	// befinden wir uns in einem "Page Tree"?
	$pages = 0;		// hier wird die Seitenzahl gespeichert
	$hasParent = 0;		// gibt an, ob ein Parent-Parameter vorhanden ist

	while( !feof( $pdffile ) )
	{
		// eine Zeile lesen
		$line = fgets( $pdffile, 512 );

		// $in_page_tree nur dann auf 1 setzen, wenn man zwischen "/Type /Pages" und "endobj" ist
		if( ereg( "/Type /Pages", $line ) )
		{
			$in_page_tree = 1;
			$hasParent = 0;
		}
		elseif( ereg( "endobj", $line ) )
		{
			// wenn wir aus dem "Page Tree" wieder drauen sind, kein "/Parent" gekommen ist
			// und wir aber eine Seitenzahl ermittelt haben, war es die richtige Seitenzahl
			if( (0 == $hasParent) && (0 != $pages) )
			{
				break;
			}

			$hasParent = 0;
			$in_page_tree = 0;
		}

		// wenn $in_page_tree gleich 1 ist und der Parameter "/Count" kommt, den Wert speichern, und raus aus der Schleife
		if( (1 == $in_page_tree) && ( ereg( "/Count ([0-9]*)", $line, $regs ) ) )
		{
			$pages = $regs[1];
		}

		// wenn $in_page_tree gleich 1 ist und "/Parent" gefunden wurde, dann ist es nicht die richtige
		// Seitenzahl, weil das Seiten-Objekt ein Vater-Objekt hat, in dem die richtige Zahl drinsteht
		if( (1 == $in_page_tree) && ( ereg( "/Parent", $line ) ) )
		{
			$hasParent = 1;
		}
	}

	fclose( $pdffile );

	return $pages;
}

// liefert den Titel und die Beschreibung zu einer Datei; diese
// Informationen werden aus der Beschreibungsdatei gelesen (die den selben
// Namen, aber die Endung .txt hat) - wenn diese Datei fehlt, wird
// als Titel der Dateiname und als Beschreibung ein leerer Text geliefert
function get_description( $file, &$title, &$description )
{
	$content = array();	// Array, das den Dateiinhalt aufnimmt
	$description = "";
	$title = htmlentities( $file );

	ereg( "(.+)(\..{3,4})", $file, $regs );		// Dateiname und Endung (3-4 Zeichen) trennen
	$filename_description = $regs[1] . ".txt";		// neue Endung .txt

	if( is_readable( $filename_description ) )		// wenn diese Datei existiert:
	{
		$content = file( $filename_description );	// Datei in ein Array einlesen

		// der Titel steht in der ersten Zeile (chop() entfernt den Zeilenumbruch am Ende)
		$title = chop( array_shift( $content ) );

		$description = join( "", $content );	// die Beschreibung steht in den restlichen Zeilen
	}
}

function process_file( $filename )
{
	global $output;
	global $current_dir;
	global $use_downloadcounter;
	$files = array();		// ein leeres Array anlegen

	ereg( "(.+)(\..{3,4})", $filename, $regs );		// Dateiname und Endung (3-4 Zeichen) trennen
	$name = $regs[1];
	$extension = $regs[2];

	// Textdateien knnen wir nicht gebrauchen, denn die dienen als Beschreibung
	if( (".txt" == $extension) || (".cnt" == $extension) )
	{
		return;
	}

	// Alle Verzeichnisnamen kodieren, dann mit Schrgstrichen zusammenbauen
	// => Ziel: Sonderzeichen werden kodiert, nicht aber die Pfad-Trenner.
	array_push( $current_dir, rawurlencode( $filename ) );
	$fullname = join( "/", $current_dir );
	array_pop( $current_dir );

	// Beschreibung ermitteln
	get_description( $filename, $title, $description );

	// Dateigre in kB bestimmen
	$size = round( filesize( $filename ) / 1024 );	// Dateigre in kB

	// wenn es eine PDF-Datei ist: Seitenzahl bestimmen
	if( ".pdf" == strtolower( $extension ) )
	{
		$pages = count_pdf_pages( $filename );

		if( $pages > 1 )	// mehrere Seiten
		{
			$size_text = "$pages Seiten, $size kB";
		}
		elseif( 1 == $pages )	// eine Seite: Singular statt Plural
		{
			$size_text = "1 Seite, $size kB";
		}
		elseif( 0 == $pages )	// wenn 0 zurckgeliefert: Seitenzahl konnte nicht ermittelt werden, Fragezeichen ausgeben
		{
			$size_text = "? Seiten, $size kB";
		}
	}
	else
	{
		$size_text = "$size kB";
	}

	if( 1 == $use_downloadcounter )
	{
		// Vorgehensweise:
		// - Der Link auf die Datei wurde aus dem Array $current_dir gewonnen,
		//   dabei wurden alle Sonderzeichen kodiert. D.h. der Link ist gltig,
		//   er knnte, so wie er ist, in den Location-Header, den der Downloadcounter
		//   erzeugt, hineingeschrieben werden. Aber da er dem Downloadcounter via
		//   HTTP-GET bergeben wird, muss er noch einmal kodiert werden.
		// - Als Name des Counters wird der Link genommen, und fr die bergabe
		//   per URL ebenfalls noch einmal kodiert; im Downloadcounter muss er dafr
		//   einmal dekodiert werden, damit ein gltiger Dateiname herauskommt.
		// - Wenn der Name als PHP-Variable bergeben wird, darf er nicht kodiert sein,
		//   d.h. man nimmt den Link und dekodiert ihn gleich wieder.
		
		// beim Namen: Protokoll und Domain entfernen, damit es auf jeden Fall lokal ist
		$countername = ereg_replace( "[:alpha:]+://[^[:space:]<>/]/", "", $fullname );
		
		fputs( $output, "\t\t<LI><A href=\"downloadcounter.php?name=" . rawurlencode( $countername ) . "&url=" . rawurlencode( $fullname ) . "\"><STRONG>$title</STRONG></A> (<?php \$name=\"" . rawurldecode( $countername ) . "\"; showLog();?> Downloads)<BR>\n" );
	}
	else
	{
		// Link erzeugen (Link, Beschreibung, Gre)
		fputs( $output, "\t\t<LI><A href=\"$fullname\"><STRONG>$title</STRONG></A><BR>\n" );
	}

	if( "" != $description )
	{
		fputs( $output, "\t\t$description<BR>\n" );
	}
	fputs( $output, "\t\t<I>$size_text</I>\n" );

	// wenn ein Unterverzeichnis mit dem gleichen Namen wie die Datei existiert
	// Der folgende Code (innerhalb des if-Blocks) ist derselbe wie in walk_dir() !!!
	if( is_dir( $name ) )
	{
		// rein ins Verzeichnis (und Pfad notieren)
		chdir( $name );
		array_push( $current_dir, rawurlencode( $name ) );

		$handle = opendir( "." );	// Unterverzeichnis ffnen

		// jetzt sind die Dateien innerhalb des aktuellen Verzeichnisses dran
		while( $file = readdir( $handle ) )
		{
			// wenn es eine echte Datei ist: im Array speichern (zwecks alphabetischer Sortierung)
			if( is_file( $file ) )
			{
				ereg( "(.+)(\..{3,4})", $file, $regs );		// Dateiname und Endung (3-4 Zeichen) trennen

				// Textdateien knnen wir nicht gebrauchen, denn die dienen als Beschreibung
				if( (".txt" != $regs[2]) && (".cnt" != $regs[2]) )
				{
					// XXX: evtl. Beschreibung holen, um nach Beschreibung zu sortieren, statt nach Dateiname

					array_push( $files, $file );
				}
			}
		}

		closedir( $handle );		// Unterverzeichnis schlieen

		// Dateien alphabetisch sortieren
		rsort( $files );

		$in_itemize = 0;	// wir sind in keiner Aufzhlungsliste

		while( $file = array_pop( $files ) )
		{
			// damit eine Liste nur dann angelegt wird, wenn tatschlich Elemente vorhanden sind
			if( 0 == $in_itemize )
			{
				fputs( $output, "\t<UL>\n" );
				$in_itemize = 1;
			}

			echo( "Zusatzdatei gefunden: $file<BR>\n" );
			process_file( $file );
		}

		if( 1 == $in_itemize )
		{
			fputs( $output, "\t</UL>\n\n" );
		}

		chdir( ".." );
		array_pop( $current_dir );
	}

	// Ende des Listeneintrags
	fputs( $output, "\t\t</LI>\n" );
}

// erzeugt eine Liste der Unterverzeichnisse
// diese Liste sind Links auf die nachfolgenden Eintrge,
// die Anker werden mit rawurlencode() aus dem Verzeichnisnamen erzeugt
function link_directories()
{
	global $output;

	$in_itemize = 0;		// gibt an, ob man sich in einer Aufzhlung befindet
	$directories = array();		// ein leeres Array anlegen

	$handle = opendir( "." );	// aktuelles Verzeichnis ffnen

	echo( "Erstellung der Links auf Textanker ...<BR>" );

	while( $file = readdir( $handle ) )	/* nchsten Eintrag lesen, bis keiner mehr kommt */
	{
		// wenn es ein Verzeichnis ist, und zwar nicht "." oder ".."
		// (und sicherheitshalber kein Link, da ansonsten Deadlock mglich), dann
		// in Array speichern, damit man spter reingehen kann, nachdem alle anderen Dateien abgearbeitet sind
		if( is_dir( $file ) && ( $file != "." ) && ( $file != ".." ) && (! is_link( $file )) )
		{
			array_push( $directories, $file );
		}
	}

	// weil die Dateien bei array_pop() in umgekehrter Reihenfolge geholt werden, sortieren wir es
	// jetzt in umgekehrter Reihenfolge, damit es dann wieder stimmt
	rsort( $directories );

	while( $file = array_pop( $directories ) )
	{
		$anchor = rawurlencode( $file );

		// damit eine Liste nur dann angelegt wird, wenn tatschlich Elemente vorhanden sind
		if( 0 == $in_itemize )
		{
			fputs( $output, "\t<UL>\n" );
			$in_itemize = 1;
		}

		fputs( $output, "\t\t<LI><A href=\"#$anchor\" target=\"Inhalt\">" . htmlentities($file) . "</A></LI>\n" );
		echo( "Anker erstellt: \"$anchor\"<BR>" );
			
	}

	if( 1 == $in_itemize )
	{
		fputs( $output, "\t</UL>\n\n" );
	}

	closedir( $handle );
}

// Durchluft ein Verzeichnis, ruft process_file() zum Bearbeiten der Dateien auf
// (Erstellen von Links, Zhlen der Seiten von PDF usw.) bzw. sich selbst rekursiv fr Unterverzeichnisse.
function walk_dir()
{
	global $output;			// Datei, in die alle Ausgaben geschrieben werden sollen
	global $SCRIPT_NAME;		// Dateiname des PHP-Programms
	global $current_dir;		// Array, das den momentanen Pfad enthlt
	$directories = array();		// ein leeres Array anlegen
	$files = array();		// ein leeres Array anlegen

	$handle = opendir( "." );	// Verzeichnis ffnen

	// nchsten Verzeichniseintrag lesen, bis keiner mehr kommt
	while( $file = readdir( $handle ) )
	{
		// wenn es ein Verzeichnis ist, und zwar nicht "." oder ".."
		// (und sicherheitshalber kein Link, da ansonsten Deadlock mglich), dann
		// in Array speichern, damit man spter reingehen kann, nachdem alle anderen Dateien abgearbeitet sind
		if( is_dir( $file ) && ( $file != "." ) && ( $file != ".." ) && (! is_link( $file )) )
		{
			array_push( $directories, $file );
		}
	}

	closedir( $handle );		// Verzeichnis wieder schlieen

	// weil die Dateien bei array_pop() in umgekehrter Reihenfolge geholt werden, sortieren wir es
	// jetzt in umgekehrter Reihenfolge, damit es dann wieder stimmt
	rsort( $directories );

	// die Verzeichnisse in alphabetischer Reihenfolge in die HTML-Datei einfgen
	while( $dir = array_pop( $directories ) )
	{
		// zuerst aus dem Verzeichnisnamen einen Anker erzeugen (zu dem kann man dann
		// mit <A href="#ankername"> springen, link_directories() erzeugt die Links)
		$anchor = rawurlencode( $dir );
		$dirname = htmlentities( $dir );
		fputs( $output, "\t<H2><A name=\"$anchor\">$dirname</A></H2>\n\n" );
		echo( "Verzeichnis gefunden: $dir<BR>" );

		// Untersuchung der Dateien im Unterverzeichnis;
		// hier muss das Verzeichnis gewechselt werden, weil PHP den Dateityp
		// nicht erkennt, wenn der Dateiname mit Pfad angegeben wird - seltsamer Effekt!
		chdir( $dir );
		array_push( $current_dir, rawurlencode( $dir ) );

		$handle = opendir( "." );	// Unterverzeichnis ffnen

		// jetzt sind die Dateien innerhalb des aktuellen Verzeichnisses dran
		while( $file = readdir( $handle ) )
		{
			// wenn es eine echte Datei ist: im Array speichern (zwecks alphabetischer Sortierung)
			if( is_file( $file ) )
			{
				ereg( "(.+)(\..{3,4})", $file, $regs );		// Dateiname und Endung (3-4 Zeichen) trennen

				// Textdateien knnen wir nicht gebrauchen, denn die dienen als Beschreibung
				if( (".txt" != $regs[2]) && (".cnt" != $regs[2]) )
				{
					// XXX: evtl. Beschreibung holen, um nach Beschreibung zu sortieren, statt nach Dateiname

					array_push( $files, $file );
				}
			}
		}

		closedir( $handle );		// Unterverzeichnis schlieen

		// Dateien alphabetisch sortieren
		rsort( $files );

		$in_itemize = 0;	// wir sind in keiner Aufzhlungsliste

		while( $file = array_pop( $files ) )
		{
			// damit eine Liste nur dann angelegt wird, wenn tatschlich Elemente vorhanden sind
			if( 0 == $in_itemize )
			{
				fputs( $output, "\t<UL>\n" );
				$in_itemize = 1;
			}

			echo( "Datei gefunden: $file<BR>\n" );
			fputs( $output, "\t\t<P>\n" );
			process_file( $file );
			fputs( $output, "\t\t</P>\n\n" );
		}

		if( 1 == $in_itemize )
		{
			fputs( $output, "\t</UL>\n\n" );
		}

		// wieder zurck ins Wurzelverzeichnis
		chdir( ".." );

		array_pop( $current_dir );
	}
}

// Arbeitet wie die Funktion fpassthru(), die den Inhalt einer offenen Datei (ab dem Dateizeiger) nach stdout schreibt;
// der Unterschied ist, dass hier nicht nach stdout, sondern die im Hauptprogramm geffnete Datei $output
function fpassthru_file( $inputfile )
{
	global $output;
	
	// Gre der Eingabedatei ermitteln
	$backup_fp = ftell( $inputfile );
	fseek( $inputfile, 0, SEEK_END );
	$max_inputsize = ftell( $inputfile );
	fseek( $inputfile, $backup_fp, SEEK_SET );

	// aus Eingabedatei lesen und in Ausgabedatei schreiben
	fwrite( $output, fread( $inputfile, $max_inputsize ) );

	// Eingabedatei schlieen (macht fpassthru() auch so)
	fclose( $inputfile );
}


// HAUPTPROGRAMM

	echo( "Freier Speicherplatz: " . round( diskfreespace( "." ) / (1024*1024) ) . " MB<BR>" );

	if( 1 == $use_downloadcounter )
	{
		// Ausgabedatei ffnen; Achtung, hierzu muss das Verzeichnis writeable fr das PHP sein!
		$output = fopen( "index.php", "wb" ) or die( "Fehler: Konnte Ausgabedatei nicht ffnen (index.php)." );
		echo( "Ausgabedatei ge&ouml;ffnet (index.php)" );
	}
	else
	{
		// Ausgabedatei ffnen; Achtung, hierzu muss das Verzeichnis writeable fr das PHP sein!
		$output = fopen( "index.html", "wb" ) or die( "Fehler: Konnte Ausgabedatei nicht ffnen (index.html)." );
		echo( "Ausgabedatei ge&ouml;ffnet (index.html)" );
	}
	
	// zuerst Seitenanfang ausgeben
	$file = fopen( "head.html", "rb" ) or die( "Fehler: Konnte Kopfdatei nicht &ouml;ffnen (head.html)." );
	fpassthru_file( $file );
	echo( "Kopf geschrieben (aus head.html)<BR>" );

	if( 1 == $use_downloadcounter )
	{
		fputs( $output, '<?php include "downloadcounter.php"?>' );
	}
	
	// Zuerst eine verlinkte Zusammenfassung aller Verzeichnisse erzeugen
	link_directories();
	
	// Dann durch die Verzeichnishierarchie gehen
	walk_dir();
	
	// als Vorletztes eine horizontale Linie mit Datum
	$datestring = "Letzte Aktualisierung: " . date( "d.m.Y  H:i:s" );
	fputs( $output, "<HR>\n<DIV align=\"right\">$datestring</DIV>\n\n" );

	// zum Schluss Seitenende ausgeben
	$file = fopen( "tail.html", "rb" ) or die( "Fehler: Konnte Enddatei nicht &ouml;ffnen (tail.html)" );
	fpassthru_file( $file );
	echo( "Ende geschrieben (aus tail.html)<BR>" );

	fclose( $output );

	echo( "<P></P><P></P>\nFertig!<BR>\n" );

	if( 1 == $use_downloadcounter )
	{
		echo( '<A href="index.php" target="_blank">Neu generierte Seite</A> (erzeugt: ' . date( "d.m.Y  H:i:s" ) . ")\n" );
	}
	else
	{
		echo( '<A href="index.html" target="_blank">Neu generierte Seite</A> (erzeugt: ' . date( "d.m.Y  H:i:s" ) . ")\n" );
	}
?>

	<HR>
	<SMALL>&copy; 2002 Christoph Moder</SMALL>

</BODY>
</HTML>
